#include <iostream>
#include "vector"
#include "algorithm"
#include "numeric"
#include "climits"
#include "iomanip"
#include "bitset"
#include "cmath"
#include "map"
#include "deque"
#include "array"
#include "set"
#define all(x) x.begin(), x.end()
using namespace std;
#define int long long
vector<vector<int>> g;
struct segtree {
    int sz;
    vector<int> tree;
    void init(int n) {
        sz = 1;
        while (sz <= n)
            sz *= 2;
        tree.assign(sz * 2, 0);
    }
    void addseg(int v, int x) {
        v += sz;
        while (v) {
            tree[v] += x;
            v /= 2;
        }
    }
    int getval(int l, int r) {
        int res = 0;
        l += sz;r += sz;
        while (l <= r) {
            if (l % 2 == 1) {
                res += tree[l];
                l++;
            }
            if (r % 2 == 0) {
                res += tree[r];
                r--;
            }
            l /= 2;
            r /= 2;
        }
        return res;
    }
};
vector<int> vals;
int sm = 0;
int t = 0;
int K = 20;
vector<int> dep;
vector<pair<int, int>> tinout;
segtree sg;
vector<vector<int>> binup;
void dfs(int v, int p) {
    dep[v] = dep[p] + 1;
    binup[v][0] = p;
    for (int i = 1; i < K; ++i) {
        binup[v][i] = binup[binup[v][i-1]][i-1];
    }
    //cout << v << ' ' << p << '\n';
    tinout[v].first = t++;
    for (auto i : g[v]) {
        if (i != p)
            dfs(i, v);
    }
    tinout[v].second = t;
    sg.addseg(tinout[v].first, vals[v]);
}
bool isbt(pair<int, int> bt, pair<int, int> sn) {
    return (bt.first <= sn.first and sn.second <= bt.second);
}
int lca(int a, int b) {
    if (isbt(tinout[a], tinout[b]))
        return a;
    if (isbt(tinout[b], tinout[a]))
        return b;
    for (int k = K - 1; k >= 0; --k) {
        if (isbt(tinout[binup[b][k]], tinout[a]) == 0) {
            b = binup[b][k];
        }
    }
    return binup[b][0];
}
int kmove(int v, int k) {
    for (int i = 0; i < K; ++i) {
        if (k & (1 << i)) {
            v = binup[v][i];
        }
    }
    return v;
}
pair<int, int> upd(pair<int, int> a, pair<int, int> b) {
    if (a.first == -1)
        return b;
    if (b.first == -1)
        return a;
    if (a.first * 2 < sm)
        return b;
    if (b.first * 2 < sm)
        return a;
    return min(a, b);
}
int vertbst(int bt, int sn) {
    int l = -1, r = dep[sn] - dep[bt] + 1;
    pair<int, int> res = {sg.getval(tinout[bt].first, tinout[bt].second - 1), bt};
    while (l + 1 < r) {
        int m = l + r >> 1;
        int v = kmove(sn, m);
        pair<int, int> mr = {sg.getval(tinout[v].first, tinout[v].second - 1), v};
        res = upd(res, mr);
        if (mr.first * 2 >= sm) {
            r = m;
        } else {
            l = m;
        }
    }
    //cerr << sg.getval(tinout[1].first, tinout[1].second - 1) << '\n';
    //cerr << kmove(sn, r) + 1 << '\n';
    if (r != dep[sn] - dep[bt] + 1) {
        int v = kmove(sn, r + 1);
        int vl = sg.getval(tinout[v].first, tinout[v].second - 1) - vals[v];
        if (res.first == vl and res.second > v and vl * 2 == sm) {
            res.second = v;
        }
    }
    return res.second;
}
int calccalc(int lv, int rv) {
    int lc = lca(lv, rv);
    int v1 = vertbst(lc, lv), v2 = vertbst(lc, rv);
    pair<int, int> vl1 = {sg.getval(tinout[v1].first, tinout[v1].second - 1), v1};
    pair<int, int> vl2 = {sg.getval(tinout[v2].first, tinout[v2].second - 1), v2};
    return upd(vl1, vl2).second;
}
signed main() {
    ios::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);
    int n;
    cin >> n;
    binup.assign(n, vector<int>(K));
    g.assign(n, {});
    for (int i = 1; i < n; ++i) {
        int a, b;
        cin >> a >> b;
        a--;b--;
        g[a].push_back(b);
        g[b].push_back(a);
    }
    vals.assign(n, 0);
    for (int i = 0; i < n; ++i) {
        cin >> vals[i];
        sm += vals[i];
    }
    //cout << "DA\n";
    sg.init(n);
    //cout << "DA\n";
    tinout.assign(n, {});
    //cout << "DA\n";
    dep.assign(n, -1);
    dfs(0, 0);
    //cout << "BOBR\n";
    int ind = -1, vll = 1e18;
    for (int i = 0; i < n; ++i) {
        int vl = sg.getval(tinout[i].first, tinout[i].second - 1);
        //cout << i << ' ' << vl << '\n';
        if (vl * 2 >= sm) {
            if (vll > vl) {
                vll = vl;
                ind = i;
            }
        }
    }
    int tt = binup[ind][0], vlt = sg.getval(tinout[tt].first, tinout[tt].second - 1) - vals[tt];
    if (vll == vlt and ind > tt and vll * 2 == sm) {
        ind = tt;
    }
    cout << ind + 1 << '\n';
    int q;
    cin >> q;
    for (int i = 0; i < q; ++i) {
        int h, c;
        cin >> c >> h;
        h--;
        vals[h] += c;
        sm += c;
        sg.addseg(tinout[h].first, c);
        ind = calccalc(ind, h);
        cout << ind + 1 << '\n';
    }
}
/*
4
1 4
4 2
2 3
1 1 1 1
1
2 3
 */